/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database.interpret;

import com.mckoi.database.DataTableColumnDef;
import com.mckoi.database.DataTableDef;
import com.mckoi.database.DatabaseConnection;
import com.mckoi.database.DatabaseException;
import com.mckoi.database.Expression;
import com.mckoi.database.StatementException;
import com.mckoi.database.TableName;
import com.mckoi.database.Variable;
import java.util.ArrayList;
import java.util.List;

abstract class ColumnChecker {
    ColumnChecker() {
    }

    static String stripTableName(String table_domain, String column) {
        if (column.indexOf(46) != -1) {
            String st = table_domain + ".";
            if (!column.startsWith(st)) {
                throw new StatementException("Column '" + column + "' is not within the expected table domain '" + table_domain + "'");
            }
            column = column.substring(st.length());
        }
        return column;
    }

    static ArrayList stripColumnList(String table_domain, ArrayList column_list) {
        if (column_list != null) {
            int size = column_list.size();
            for (int i = 0; i < size; ++i) {
                String res = ColumnChecker.stripTableName(table_domain, (String)column_list.get(i));
                column_list.set(i, res);
            }
        }
        return column_list;
    }

    abstract String resolveColumnName(String var1) throws DatabaseException;

    void checkExpression(Expression expression) throws DatabaseException {
        if (expression != null) {
            List list = expression.allVariables();
            for (int i = 0; i < list.size(); ++i) {
                Variable v = (Variable)list.get(i);
                String orig_col = v.getName();
                String resolved_column = this.resolveColumnName(orig_col);
                if (resolved_column == null) {
                    throw new DatabaseException("Column '" + orig_col + "' not found in the table.");
                }
                if (orig_col.equals(resolved_column)) continue;
                v.setColumnName(resolved_column);
            }
            if (expression.hasSubQuery()) {
                throw new DatabaseException("Sub-queries not permitted in the check constraint expression.");
            }
        }
    }

    void checkColumnList(ArrayList list) throws DatabaseException {
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                String col = (String)list.get(i);
                String resolved_col = this.resolveColumnName(col);
                if (resolved_col == null) {
                    throw new DatabaseException("Column '" + col + "' not found the table.");
                }
                list.set(i, resolved_col);
            }
        }
    }

    static ColumnChecker standardColumnChecker(DatabaseConnection database, TableName tname) {
        final DataTableDef table_def = database.getTable(tname).getDataTableDef();
        final boolean ignores_case = database.isInCaseInsensitiveMode();
        return new ColumnChecker(){

            String resolveColumnName(String col_name) throws DatabaseException {
                String found_col = null;
                for (int n = 0; n < table_def.columnCount(); ++n) {
                    DataTableColumnDef col = table_def.columnAt(n);
                    if (!ignores_case) {
                        if (!col.getName().equals(col_name)) continue;
                        return col_name;
                    }
                    if (!col.getName().equalsIgnoreCase(col_name)) continue;
                    if (found_col != null) {
                        throw new DatabaseException("Ambiguous column name '" + col_name + "'");
                    }
                    found_col = col.getName();
                }
                return found_col;
            }
        };
    }
}

